// The app shows images from image gallery and use can flick through them
// below the image is animated reflection that is calculated using OpenGL Shader
import QtQuick 1.1
import Qt.labs.shaders 1.0
import QtMobility.gallery 1.1
import Sailfish.Silica 1.0

ApplicationWindow {
    Column{
        anchors.fill: parent

        // A view for flicking through a series of items
        SlideshowView {
            id: coverArea
            width: parent.width
            height: parent.height / 2
            itemWidth: width

            // Retrieve images from gallery
            // model defines what data to show
            model: DocumentGalleryModel {
                rootType: DocumentGallery.Image
                properties: [ "url" ]
            }

            // Delegate ("view") defines how an item of the model
            // is shown.
            delegate: Image {
                source: url
                width: parent.width
                height: parent.height

                // Scale images to fit view
                sourceSize {
                    width: coverArea.itemWidth
                    height: coverArea.height
                }
                fillMode: Image.PreserveAspectCrop
            }
        }

        // Shader that creates illusion of reflection
        ShaderEffectItem {
            id: reflectionEffect

            property real phase

            // height for our waves from the slider element defined below
            property real waveHeight: heightSlider.value

            property variant source: ShaderEffectSource {
                sourceItem: coverArea
            }
            width: parent.width
            height: coverArea.height / 2


            fragmentShader: "
            uniform highp float phase;
            uniform highp float waveHeight;
            varying highp vec2 qt_TexCoord0;
            uniform sampler2D source;
            void main() {
                highp vec4 col = texture2D(source, vec2(
                          fract(qt_TexCoord0.x+sin(phase+qt_TexCoord0.y*30.0)*0.009),
                          fract(1.0-qt_TexCoord0.y+sin(phase+qt_TexCoord0.x*15.0)*waveHeight)));
                gl_FragColor = mix(col,vec4(0.0,0.0,0.0,1.0),1.0 - qt_TexCoord0.y);
            }"

            // Create animation to shader by animating phase property
            // which shader uses
            NumberAnimation on phase {
                running: activationSwitch.checked
                loops: Animation.Infinite
                from: 0; to: 2 * Math.PI
                duration: 3000;
            }
        }

        // on/off togle for animation
        TextSwitch {
            id: activationSwitch
            checked: true
            text: "Animate"
            description: "Animate the reflection"
        }

        // Slider for adjusting wave height
        Slider {
            id: heightSlider
            minimumValue: 0.001; maximumValue: 0.1
            value: 0.005
            width: parent.width
        }
    }
}
